/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.client.screen.basic.createEntry;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.sixik.sdmshoprework.SDMShopClient;
import net.sixik.sdmshoprework.SDMShopPaths;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.client.screen.basic.createEntry.AbstractCreateEntryScreen;
import net.sixik.sdmshoprework.common.shop.ShopEntry;
import net.sixik.sdmshoprework.network.server.create.SendCreateShopEntryC2S;

public abstract class AbstractCreateEntryButton
extends SimpleTextButton {
    public AbstractShopEntryType shopEntryType;

    public AbstractCreateEntryButton(Panel panel, AbstractShopEntryType entryType) {
        super(panel, (Component)Component.m_237119_(), entryType.getCreativeIcon());
        this.shopEntryType = entryType;
    }

    public boolean isActive() {
        return Platform.isModLoaded((String)this.shopEntryType.getModId());
    }

    public void onClicked(MouseButton mouseButton) {
        if (this.isActive()) {
            AbstractCreateEntryScreen screen = (AbstractCreateEntryScreen)this.getGui();
            if (mouseButton.isLeft()) {
                ShopEntry create = new ShopEntry(screen.shopScreen.selectedTab);
                create.setEntryType(this.shopEntryType.copy());
                screen.shopScreen.selectedTab.getTabEntry().add(create);
                new SendCreateShopEntryC2S(screen.shopScreen.selectedTab.shopTabUUID, create.serializeNBT()).sendToServer();
                screen.closeGui();
                screen.shopScreen.addEntriesButtons();
            }
            if (mouseButton.isRight()) {
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                if (!SDMShopClient.creator.favoriteCreator.contains(this.shopEntryType.getId())) {
                    contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.creator.addfavorite"), Icons.ADD, () -> {
                        SDMShopClient.creator.favoriteCreator.add(this.shopEntryType.getId());
                        SNBT.write((Path)SDMShopPaths.getFileClient(), (CompoundTag)SDMShopClient.creator.serializeNBT());
                    }));
                } else {
                    contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.creator.removefavorite"), Icons.REMOVE, () -> {
                        SDMShopClient.creator.favoriteCreator.remove(this.shopEntryType.getId());
                        SNBT.write((Path)SDMShopPaths.getFileClient(), (CompoundTag)SDMShopClient.creator.serializeNBT());
                    }));
                }
                screen.openContextMenu(contextMenu);
            }
        }
    }

    public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
        SDMShopClient.getTheme().draw(graphics, x, y, w, h);
    }
}

